require( "scripts/transitions.lua" );

---------------------------------------------------------- Illegal Name Characters
kIllegalNameChars = "!@#$%^&*()><\\\"\'[]{}|?/+=~`.,;:-";

---------------------------------------------------------- Colors
BlackColor		= Color(0,0,0,245);
DarkBlueColor	= Color(40,60,120,245);
WhiteColor		= Color(255,255,255,245);
GreyColor		= Color(154,154,154,245);
ShadowColor		= Color(0,0,0,150);
WhiteFadedColor = Color(255,255,255,150);

---------------------------------------------------------- Fonts
myriad_pro		= "fonts/myriad_pro.mvec";
eccentric_std	= "fonts/eccentric_std.mvec";
carlson_pro		= "fonts/carlson_pro.mvec";
edwardian_medium = "fonts/edwardian_medium.mvec";
califpro_regular = "fonts/califpro_regular.mvec";
caflisch_regular = "fonts/caflisch_regular.mvec";
---------------------------------------------------------- Sounds
kDefaultButtonSound = "audio/sfx/buttonclick.ogg";
kChompButtonSound = "audio/sfx/chomp.ogg";

kSFXSoundGroup = 1000;
kMusicSoundGroup = 1001;
---------------------------------------------------------- Styles
----------------------------- App
App_StandardButtonFont = {
	edwardian_medium,
	18,
	BlackColor
};

App_MenuButtonFont = {
	edwardian_medium,
	22,
	WhiteColor
};

App_MenuButtonFontBig = {
	edwardian_medium,
	25,
	BlackColor
};
App_MenuButtonFontSmall = {
	edwardian_medium,
	25,
	WhiteColor
};

App_MenuSmallFont = {
	edwardian_medium,
	20,
	WhiteColor
};

App_StandardButtonGraphics = {
	"ui/buttons/buttonup",
	"ui/buttons/buttondown",
	"ui/buttons/buttonrollover"
};

App_LongButtonGraphics = {
	"ui/buttons/long_button_up.png",
	"ui/buttons/long_button_down.png",
	"ui/buttons/long_button_over.png"
};

App_CheckboxButtonGraphics = {
	"ui/buttons/options_off",
	"ui/buttons/options_on",
	"ui/buttons/options_off",
	"ui/buttons/options_on"
};

App_OrangeSmallButtonGraphics = {
	"ui/buttons/el_quit_up",
	"ui/buttons/el_quit_down",
	"ui/buttons/el_quit_over"
};

App_DefaultStyle = {
	font = Dialog_BodyFont
};

App_SliderStyle = {
	parent			= App_DefaultStyle,
	railtop			= "ui/slider/sliderrailtop",
	railmid			= "ui/slider/sliderrailmid",
	railbot			= "ui/slider/sliderrailbot",
	sliderimage		= "ui/slider/sliderknob",
	sliderrollimage = "ui/slider/sliderknobover",
	yoffset			= -1,
};

App_MenuButtonStyle = {
	parent		= App_DefaultStyle,
	font		= App_MenuButtonFont,
	sound		= kDefaultButtonSound,
	flags		= kVAlignCenter,
	graphics	= {},
	w			= 169, 
	h			= 40,
};

App_ButtonStyle = {
	parent		= App_DefaultStyle,
	font		= App_StandardButtonFont,
	sound		= kDefaultButtonSound,
	type		= kPush,
	graphics	= App_StandardButtonGraphics,
};

App_LongButtonStyle = {
	parent		= App_ButtonStyle,
	graphics	= App_LongButtonGraphics
};

App_CheckboxButtonStyle = {
	parent		= App_DefaultStyle,
	font		= App_StandardButtonFont,
	type		= kToggle,
	sound		= kDefaultButtonSound,
	graphics	= App_CheckboxButtonGraphics,
};


----------------------------- Scorer
Scorer_DefaultFont = {
	myriad_pro,
	20,
	BlackColor
};

----------------------------- Timer
Timer_DefaultFont = {
	myriad_pro,
	16,
	BlackColor
};

----------------------------- ChoosePlayer
ChoosePlayer_NameFont = {
	edwardian_medium,
	18,
	WhiteColor
};

ChoosePlayer_SelectNameFont = {
	edwardian_medium,
	18,
	Color(100,100,255,255),
};

ChoosePlayer_HeaderFont = {
	edwardian_medium,
	28,
	WhiteColor
};

ChoosePlayer_NameButtonGraphics = {
	"ui/buttons/choosenameover.png",
	"ui/buttons/choosenamedown.png",
	"ui/buttons/choosenameover.png",
	"ui/buttons/choosenamedown.png"
};

ChoosePlayer_NameStyle = {
	type = kRadio,
	flags = kHAlignLeft + kVAlignCenter,
	font = ChoosePlayer_NameFont,
	graphics = {},
	sound = kDefaultButtonSound
};

ChoosePlayer_ButtonFont = {
	edwardian_medium,
	22,
	WhiteColor
};

ChoosePlayer_DisabledButtonFont = {
	edwardian_medium,
	22,
	WhiteFadedColor
};

ChoosePlayer_ButtonStyle = {
	parent		= App_DefaultStyle,
	font		= ChoosePlayer_ButtonFont,
	sound		= kDefaultButtonSound,
	type		= kPush,
	graphics	= App_StandardButtonGraphics,
};

----------------------------- Credits
Credits_TitleFont = {
	edwardian_medium,
	70,
	BlackColor
};
Credits_VersionFont = {
	edwardian_medium,
	16,
	BlackColor
};
----------------------------- Entername
Entername_TitleFont = {
	edwardian_medium,
	30,
	BlackColor
};

Entername_NameFont = {
	edwardian_medium,
	20,
	BlackColor
};

----------------------------- Options
Options_SliderFont = {
	edwardian_medium,
	24,
	WhiteColor
};
Options_CheckFont = {
	edwardian_medium,
	20,
	WhiteColor
};
Options_SliderFontShadow = {
	edwardian_medium,
	16,
	ShadowColor
};
Options_GreyFont = {
	edwardian_medium,
	16,
	GreyColor
};
Options_TitleFont = {
	edwardian_medium,
	46,
	WhiteColor
};
Options_TitleFontShadow = {
	edwardian_medium,
	46,
	ShadowColor
};

Options_SliderStyle = {
	parent			= App_DefaultStyle,
	railtop			= "ui/slider/transparent",
	railmid			= "ui/slider/transparent",
	railbot			= "ui/slider/transparent",
	sliderimage		= "ui/slider/sliderknob_blimp",
	sliderrollimage = "ui/slider/sliderknob_over",
};

----------------------------- Prelevel
Prelevel_SmallFont = {
	edwardian_medium,
	16,
	WhiteColor
};
Prelevel_MediumFont = {
	edwardian_medium,
	36,
	WhiteColor
};
Prelevel_MediumShadowFont = {
	edwardian_medium,
	36,
	ShadowColor
};
Prelevel_TitleFont = {
	edwardian_medium,
	46,
	WhiteColor
};
Prelevel_TitleShadowFont = {
	edwardian_medium,
	46,
	ShadowColor
};
Prelevel_PriceFont = {
	edwardian_medium,
	18,
	WhiteColor
};
Prelevel_PriceShadowFont = {
	edwardian_medium,
	18,
	ShadowColor
};

----------------------------- Dialog
Dialog_TitleFont = {
	edwardian_medium,
	25,
	WhiteColor
};

Dialog_BodyFont = {
	edwardian_medium,
	22,
	WhiteColor
};

-- Sets the default style of the application
SetDefaultStyle( App_DefaultStyle );

---------------------------------------------------------- Overloads

-- Create a TButton with a label
--
-- We're overriding the default "Button" here with
-- some custom behavior. Specifically, we're layering
-- a Text{} object on top of every button, and it's placed
-- on all layers (up, down, roll-over).
function Button( button )
	return function()
	
		-- Grab the label from the button or current style
		if( GetTag( button, "label" ) ) then

			-- Look for text dimensions that may be defined
			local tx = GetTag( button, "tx" );
			local ty = GetTag( button, "ty" );
			local tw = GetTag( button, "tw" );
			local th = GetTag( button, "th" );

			-- Set defaults
			if( not tx ) then
				tx = 0;
			end
			if( not ty ) then
				ty = 0;
			end
			if( not tw ) then
				tw = kMax;
			end
			if (not th) then
				th = kMax;
			end

			-- Get the label
			local label = GetTag( button, "label" );
			
			local defflags = kPushButtonAlignment;
			if( GetTag( button, "type" ) == kToggle ) then
				defflags = kToggleButtonAlignment;
			elseif( GetTag( button, "type" ) == kRadio ) then
				defflags = kRadioButtonAlignment;
			end

			--local textfactory = GetTag( button, "textfactory" );
			--if( not textfactory ) then
			--	textfactory = "_text"
			--end
			
			-- Insert a select of all of the layers to our table
			table.insert( button, SelectLayer( kAllLayers ) );
			
			-- Grow our window to encompass any children we've added
			table.insert( button, FitToChildren() );

			-- Grab the font and the flags for our button's table
			table.insert( button, AppendStyle{ font = button.font; flags = button.flags; } );

			-- Insert a text object (which will show on all layers because of the select above)
			table.insert( button,
				Text
				{
					x			= tx, 
					y			= ty, 
					w			= tw, 
					h			= th,
					label		= label,
					name		= 'label',
					defflags	= defflags 
				}
			);
		end

		-- Type name of window to create; in our case, "Button"
		-- If you want to create a derived button type, you can do that here
		button.typename = 'Button';
		DoWindow( button );
	end
end